% Set the folder path containing the Excel files
folderPath = 'C:\Users\GEORGE\Documents\State Estimation\State-Estimation\SEGAN\Dataport\False Data Injection Attacks\False Data Injection Attacks\Attacked Values';  % <-- Change this to your folder

% Get list of all Excel files in the folder
fileList = dir(fullfile(folderPath, '*.xlsx'));

% Loop through each file
for k = 1:length(fileList)
    
    % Full file path
    filePath = fullfile(folderPath, fileList(k).name);
    
    % Read the data
    data = readtable(filePath);

    % Keep only the first five columns (adjust if fewer columns exist)
    numCols = min(5, width(data));
    newData = data(:, 1:numCols);

    % Overwrite the file by deleting and rewriting
    delete(filePath);  % Remove the original file
    
    % Overwrite the original file (or save to a new file if preferred)
    writetable(newData, filePath);
    
    fprintf('Processed: %s\n', fileList(k).name);
end

disp('All files processed.');